#!/usr/local/bin/perl

# iTunes Library to WinAMP Playlists 1.0

# Before you run this, you'll need to export your entire iTunes
# library as an XML file.  Place this script in the same folder
# as the file, edit the filename below if neccessary, customize
# the truncate strings if you need to (you'll probably want to
# replace my username, 'garote', with your own username), and
# save the script.

# Disclaimer: Use it at our own risk, et cetera, yadda ya.
# This script is free for all.  Modify it if you like.
# Rip out my username if you wanna.  I really don't care.
# It only took me 30 minutes anyway.

# ----------------------------------------------------------

# Relative path of your exported iTunes XML library file
$database_rel = "Library.xml";
# Relative path of a file to use as a log
$logfile_rel = "logfile.txt";
# Three possible strings to truncate from all generated playlists
$truncate_string = "file://localhost/Library/Audio/mp3s/";
$truncate_string_b = "file://localhost/Users/garote/Music/iTunes/iTunes%20Music/";
$truncate_string_c = "file://localhost/Library/Audio/Sounds/mp3s/";

$exclusive_lock = 2;
$unlock = 8;
my %master_list;

umask(0);

print "Attempting to open file '" . $database_rel . "'\n";

$entrynumber = 0;

if (open(LOGFILE, ">" . $logfile_rel))
{
   print LOGFILE "\nLogfile opened.";
}

print LOGFILE "\nImporting library file \"" . $database_rel . "\"\n";

if ( open(INFILE, $database_rel ) )
{
   @all_raw_entries = <INFILE>;
   close(INFILE);
}

print LOGFILE "\nAll entries successfully read in.";

$assembled_all = "no";

while ($assembled_all ne "yes")
{
   seek_to("<key>Track ID</key>");
   
   $track_index = pull_next();   
   #   print LOGFILE $temp . "\n";   
   $track_index =~ s/^\<integer\>//gs;
   $track_index =~ s/\<\/integer\>$//gs;    
   
   #   print LOGFILE $track_index . "\n";

   $temp = pull_next();

   if ($temp eq "</dict>")
   {
      $assembled_all = "yes";
   }
   else
   {
      seek_to("<key>Location</key>");

      $track_location = pull_next();
      #   print LOGFILE $temp . "\n";
      $track_location =~ s/^\<string\>//gs;
      $track_location =~ s/\<\/string\>$//gs;

      $track_location =~ s/^$truncate_string//s;
      $track_location =~ s/^$truncate_string_b//s;
      $track_location =~ s/^$truncate_string_c//s;

      # Convert any HTML URL escape sequences
      $track_location =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack ("C", hex ($1))/eg;
      # And those damn ampersands
      $track_location =~ s/&\#38\;/&/gs;

      $master_list{$track_index} = $track_location;
   }
}

print LOGFILE "\nHash table built.";

# By this point we've actually seeked past the end of the
# database list, and into the first playlist.
# The first playlist is always the 'master' playlist,
# however, and we're going to skip that and go to the
# user-defined playlists.  So we need to seek to the
# name of the first playlist after this one.

while (@all_raw_entries)
{
   seek_to("<key>Name</key>");
   
   $list_name = pull_next();
   #   print LOGFILE $temp . "\n";   
   $list_name =~ s/^\<string\>//gs;
   $list_name =~ s/\<\/string\>$//gs;  

   $end_of_list = "no";
   
   if (open(PLAYLISTFILE, ">" . $list_name . ".m3u"))
   {
      print LOGFILE "\nPlaylist opened: " . $list_name;

      while ($end_of_list ne "yes")
      {
         $nextline = pull_next();
         if ($nextline =~ m/integer/)
         {
            $nextline =~ s/^\<integer\>//gs;
            $nextline =~ s/\<\/integer\>$//gs;  

            print LOGFILE "\n   Index match: " . $nextline;
            print PLAYLISTFILE $master_list{$nextline} . "\n";
#            $end_of_list = "yes";
         }
         elsif (($nextline =~ m/\/array/) || ($nextline eq ""))
         {
            print LOGFILE "\n   No match: " . $nextline;
            $end_of_list = "yes";
         }
         else
         {
            print LOGFILE "\n   No match: " . $nextline;
         }
      }
      close(PLAYLISTFILE);
   }
}

print LOGFILE "\nFinished.";

close(LOGFILE);


sub seek_to
{
   local ( $seekto ) = @_;

   local $found = "";

	while ((@all_raw_entries) && ($found ne $seekto))
	{
	   $found = shift(@all_raw_entries);
#      print LOGFILE $found . "\n";
      # Turn any tabs or other mysterious space characters into blank spaces
      $found =~ s/[\t\n\r\f\b\e\a]/ /gs;
      # Truncate blank spaces from beginning and end of string
      $found =~ s/^ +//gs;
      $found =~ s/ +$//gs;    
#      print LOGFILE $found . "\n";
   }
   return $found;
}


sub pull_next
{   
   local $found = "";

	if (@all_raw_entries)
   {
      $found = shift(@all_raw_entries);
   #   print LOGFILE $found . "\n";
      # Turn any tabs or other mysterious space characters into blank spaces
      $found =~ s/[\t\n\r\f\b\e\a]/ /gs;
      # Truncate blank spaces from beginning and end of string
      $found =~ s/^ +//gs;
      $found =~ s/ +$//gs;
   #   print LOGFILE $found . "\n";
   }
   return $found;
}


# End of file itunes_library_to_m3us.pl